----------------
title : C++ 레퍼런스 - reverse 함수 (<algorithm>)
cat_title : reverse
ref_title : reverse, std::reverse
path : /C++ Reference/algorithm
publish_date : 2019-07-02
----------------

##@ cpp-ref-start

#@ reverse

`<algorithm>` 에 정의됨

```cpp-formatted
// C++ 20 이전 까지
template <class BidirIt>
void reverse(BidirIt first, BidirIt last);  // (1)

// C++ 20 이후 부터
template <class BidirIt>
constexpr void reverse(BidirIt first, BidirIt last);  // (2)

// C++ 17 부터 추가됨
template <class ExecutionPolicy, class BidirIt>
void reverse(ExecutionPolicy&& policy, BidirIt first, BidirIt last);  // (3)
```

`first` 부터 `last` 전 까지의 원소들의 순서를 역순으로 뒤집는다.

이는 마치 0 이상의 `i < (last - first) / 2` 에 대해 `first + i` 번째 원소와 `last - i` 번째 원소들 간 `swap` 을 한 것과 동일하다.

(3) 번째 버전의 경우 인자로 지정된 `ExecutionPolicy` 에 따라 수행한다.

### 인자들

* `first, last`	-	역순으로 뒤집을 원소들 (`first` 부터 `last` 전 까지)
* `policy` - 어떠한 방식으로 실행할 것인지. 자세한 내용은 `ExecutionPolicy` 참조

### 리턴값

없음

### 구현 예시

```cpp-formatted
template <class BidirIt>
void reverse(BidirIt first, BidirIt last) {
  while ((first != last) && (first != --last)) {
    std::iter_swap(first++, last);
  }
}
```

### 실행 예제

```cpp-formatted
#include <algorithm>
#include <iostream>
#include <iterator>
#include <vector>

int main() {
  std::vector<int> v{1, 2, 3};
  std::reverse(std::begin(v), std::end(v));
  for (auto e : v) std::cout << e;
  std::cout << '\n';

  int a[] = {4, 5, 6, 7};
  std::reverse(std::begin(a), std::end(a));
  for (auto e : a) std::cout << e;
}
```

```exec
321
7654
```

### 참고 자료

* `reverse_copy` : 범위 안의 원소들을 역순으로 뒤집은 것을 생성한다 (원본은 그대로 유지됨)